/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.rsf.conndata;

import com.ibm.hwmca.base.rsf.BaseRsfErrorIds;
import com.ibm.hwmca.base.rsf.conndata.DunDialInfo;
import com.ibm.hwmca.base.rsf.conndata.IspDialInfo;
import com.ibm.hwmca.base.rsf.conndata.Region;
import com.ibm.hwmca.base.rsf.conndata.RetainConnectionDataManager;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.Persistable;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistentData;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;

public class DialConfigInfo
implements BaseRsfErrorIds,
Serializable,
Persistable {
    private static final String TRACE_MASKT = "XCDIDCIT";
    private static final String TRACE_MASKF = "XCDIDCIF";
    private static final String TRACE_MASKD = "XCDIDCID";
    private static FrameworkClassLogInfo _logInfo = new FrameworkClassLogInfo(-44, "DialCfgInfo");
    private static final String persistItem = ".theInfo";
    private static String persistId = null;
    private static DialConfigInfo theInfo = new DialConfigInfo();
    private Region homeCountry = new Region("", "  ");
    private Region selectedCountry = new Region("", "  ");
    private Region selectedRegion = new Region("", "  ");
    private String dialPrefix = "";
    private String areaCode = "";
    private DunDialInfo[] selectedNumbers = new DunDialInfo[0];

    private DialConfigInfo() {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo()");
        this.loadPersistentData();
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo()");
    }

    public DialConfigInfo(PersistentData data) {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo(PersistentData)");
        Persistent persData = (Persistent)data;
        this.homeCountry = persData.homeCountry;
        this.selectedCountry = persData.selectedCountry;
        this.selectedRegion = persData.selectedRegion;
        this.dialPrefix = persData.dialPrefix;
        this.areaCode = persData.areaCode;
        this.selectedNumbers = persData.selectedNumbers;
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo(PersistentData)");
    }

    public static String getAreaCode() {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.getAreaCode()");
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.getAreaCode() - " + DialConfigInfo.theInfo.areaCode);
        return DialConfigInfo.theInfo.areaCode;
    }

    public static String getDialPrefix() {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.getDialPrefix()");
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.getDialPrefix() - " + DialConfigInfo.theInfo.dialPrefix);
        return DialConfigInfo.theInfo.dialPrefix;
    }

    public static Region getHomeCountry() {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.getHomeCountry()");
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.getHomeCountry() - " + DialConfigInfo.theInfo.homeCountry);
        return DialConfigInfo.theInfo.homeCountry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DunDialInfo[] getPhoneNumbers() {
        DunDialInfo[] newInfo;
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.getDialInfo()");
        DialConfigInfo dialConfigInfo = theInfo;
        synchronized (dialConfigInfo) {
            if (DialConfigInfo.theInfo.selectedNumbers == null) {
                newInfo = null;
            }
            newInfo = new DunDialInfo[DialConfigInfo.theInfo.selectedNumbers.length];
            for (int i = 0; i < DialConfigInfo.theInfo.selectedNumbers.length; ++i) {
                newInfo[i] = (DunDialInfo)DialConfigInfo.theInfo.selectedNumbers[i].clone();
            }
        }
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.getDialInfo()");
        return newInfo;
    }

    public static Region getSelectedCountry() {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.getSelectedCountry()");
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.getSelectedCountry() - " + DialConfigInfo.theInfo.selectedCountry);
        return DialConfigInfo.theInfo.selectedCountry;
    }

    public static Region getSelectedRegion() {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.getSelectedRegion()");
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.getSelectedRegion() - " + DialConfigInfo.theInfo.selectedRegion);
        return DialConfigInfo.theInfo.selectedRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setConfigData(Region newHomeCountry, Region newSelectedCountry, Region newSelectedRegion, String newDialPrefix, String newAreaCode, DunDialInfo[] newPhoneNumbers) {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.setConfig() - " + newHomeCountry.getName() + ", " + newSelectedCountry.getName() + ", " + newSelectedRegion.getName() + ", " + newDialPrefix + ", " + newAreaCode + ", " + "plus " + newPhoneNumbers.length + " phone numbers");
        boolean numberChange = false;
        DialConfigInfo dialConfigInfo = theInfo;
        synchronized (dialConfigInfo) {
            DialConfigInfo.theInfo.homeCountry = (Region)newHomeCountry.clone();
            DialConfigInfo.theInfo.selectedCountry = (Region)newSelectedCountry.clone();
            DialConfigInfo.theInfo.selectedRegion = (Region)newSelectedRegion.clone();
            DialConfigInfo.theInfo.dialPrefix = newDialPrefix;
            DialConfigInfo.theInfo.areaCode = newAreaCode;
            if (newPhoneNumbers == null) {
                if (DialConfigInfo.theInfo.selectedNumbers != null) {
                    numberChange = true;
                }
                DialConfigInfo.theInfo.selectedNumbers = null;
            } else {
                if (newPhoneNumbers.length != DialConfigInfo.theInfo.selectedNumbers.length) {
                    numberChange = true;
                }
                DunDialInfo[] newNumbers = new DunDialInfo[newPhoneNumbers.length];
                for (int i = 0; i < newPhoneNumbers.length; ++i) {
                    if (!numberChange && !newPhoneNumbers[i].equals(DialConfigInfo.theInfo.selectedNumbers[i])) {
                        numberChange = true;
                    }
                    newNumbers[i] = (DunDialInfo)newPhoneNumbers[i].clone();
                }
                DialConfigInfo.theInfo.selectedNumbers = newNumbers;
            }
        }
        DialConfigInfo.savePersistentData();
        if (numberChange) {
            DialConfigInfo.updateRetain();
        }
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.setConfigInfo()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setPhoneNumber(DunDialInfo newPhoneNumber, int slotId) throws IllegalArgumentException {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.setPhoneNumber() - slotId = " + slotId);
        if (slotId < 0 || slotId >= DialConfigInfo.theInfo.selectedNumbers.length) {
            String msg = "Input slotId of " + slotId + " is out of range.  Array size is " + DialConfigInfo.theInfo.selectedNumbers.length;
            IllegalArgumentException e = new IllegalArgumentException(msg);
            throw e;
        }
        DialConfigInfo dialConfigInfo = theInfo;
        synchronized (dialConfigInfo) {
            DialConfigInfo.theInfo.selectedNumbers[slotId] = (DunDialInfo)newPhoneNumber.clone();
        }
        DialConfigInfo.savePersistentData();
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.setPhoneNumber()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePersistentData() {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.savePersistentData()");
        DialConfigInfo dialConfigInfo = theInfo;
        synchronized (dialConfigInfo) {
            if (persistId == null) {
                persistId = theInfo.getClass().getName() + persistItem;
                Trace.trace(TRACE_MASKF, "   DialConfigInfo.savePersistentData() persistId = " + persistId);
            }
            PersistenceManager manager = PersistenceManager.getPersistenceManager();
            try {
                manager.write(persistId, theInfo);
            }
            catch (PersistenceException pe) {
                Trace.trace(TRACE_MASKF, "-> DialConfigInfo.savePersistentData() persistId = " + persistId);
                new FrameworkLog(_logInfo, 59, pe).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.savePersistentData()");
    }

    private void loadPersistentData() {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.loadPersistentData()");
        if (persistId == null) {
            persistId = this.getClass().getName() + persistItem;
            Trace.trace(TRACE_MASKF, "   DialConfigInfo.loadPersistentData() persistId = " + persistId);
        }
        PersistenceManager manager = PersistenceManager.getPersistenceManager();
        try {
            DialConfigInfo oldInfo = (DialConfigInfo)manager.read(persistId);
            if (oldInfo != null) {
                this.homeCountry = oldInfo.homeCountry;
                this.selectedCountry = oldInfo.selectedCountry;
                this.selectedRegion = oldInfo.selectedRegion;
                this.dialPrefix = oldInfo.dialPrefix;
                this.areaCode = oldInfo.areaCode;
                this.selectedNumbers = oldInfo.selectedNumbers;
            }
        }
        catch (PersistenceException pe) {
            Trace.trace(TRACE_MASKF, "-> DialConfigInfo.loadPersistentData() persistId = " + persistId);
            new FrameworkLog(_logInfo, 59, pe).log();
        }
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.loadPersistentData()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void validatePhoneNumbers() {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.validatePhoneNumbers()");
        String[] numbers = new String[]{};
        try {
            numbers = IspDialInfo.getAllPhoneNumbers();
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKT, "   DialConfigInfo.validatePhoneNumbers() - couldn't get phone data");
            return;
        }
        boolean errorDetected = false;
        DialConfigInfo dialConfigInfo = theInfo;
        synchronized (dialConfigInfo) {
            String baseNumber;
            for (int p = 0; p < DialConfigInfo.theInfo.selectedNumbers.length && !(baseNumber = DialConfigInfo.theInfo.selectedNumbers[p].getBaseNumber()).equals(""); ++p) {
                boolean found = false;
                for (int n = 0; n < numbers.length; ++n) {
                    if (!baseNumber.equals(numbers[n])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                int slot = p + 1;
                Trace.trace(TRACE_MASKF, "   DialConfigInfo.validatePhoneNumbers(): invalid number in slot " + slot + " of " + numbers.length + ": " + numbers[p]);
                errorDetected = true;
            }
        }
        if (errorDetected) {
            HException hexc = new HException("Configured dial-in number not supported");
            new FrameworkLog(_logInfo, 58, hexc).log();
        }
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.validatePhoneNumbers()");
    }

    private static void updateRetain() {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.updateRetain()");
        RetainConnectionDataManager.forceUpdate();
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.updateRetain()");
    }

    public PersistentData getPersistentData() {
        Trace.trace(TRACE_MASKT, "-> DialConfigInfo.getPersistentData()");
        Persistent persData = new Persistent();
        persData.homeCountry = DialConfigInfo.theInfo.homeCountry;
        persData.selectedCountry = DialConfigInfo.theInfo.selectedCountry;
        persData.selectedRegion = DialConfigInfo.theInfo.selectedRegion;
        persData.dialPrefix = DialConfigInfo.theInfo.dialPrefix;
        persData.areaCode = DialConfigInfo.theInfo.areaCode;
        persData.selectedNumbers = DialConfigInfo.theInfo.selectedNumbers;
        Trace.trace(TRACE_MASKT, "<- DialConfigInfo.getPersistentData()");
        return persData;
    }

    public boolean isUpgradeData() {
        return true;
    }

    class Persistent
    implements PersistentData {
        private static final long serialVersionUID = 7375734045300451279L;
        int version = 1;
        Region homeCountry;
        Region selectedCountry;
        Region selectedRegion;
        String dialPrefix;
        String areaCode;
        DunDialInfo[] selectedNumbers;

        Persistent() {
        }
    }
}

